<?php
if ( ! defined( 'ABSPATH' ) ) { exit; }

class AegisWAF_Page_License {

    public function render() : void {
        if ( ! current_user_can( 'manage_options' ) ) { return; }

        $lm   = new AegisWAF_License_Manager();
        $data = $lm->get_license_data();

        if ( isset( $_POST['aegiswaf_activate_license'] ) ) {
            check_admin_referer( 'aegiswaf_license_action' );
            $key   = isset( $_POST['license_key'] ) ? (string) wp_unslash( $_POST['license_key'] ) : '';
            $email = isset( $_POST['license_email'] ) ? (string) wp_unslash( $_POST['license_email'] ) : '';
            $res   = $lm->activate_license( $key, $email );
            $data  = $lm->get_license_data();
            echo '<div class="notice ' . ( ! empty( $res['success'] ) ? 'notice-success' : 'notice-error' ) . '"><p>' . esc_html( $res['message'] ?? '' ) . '</p></div>';
        }

        if ( isset( $_POST['aegiswaf_deactivate_license'] ) ) {
            check_admin_referer( 'aegiswaf_license_action' );
            $res  = $lm->deactivate_license();
            $data = $lm->get_license_data();
            echo '<div class="notice ' . ( ! empty( $res['success'] ) ? 'notice-success' : 'notice-error' ) . '"><p>' . esc_html( $res['message'] ?? '' ) . '</p></div>';
        }

        $is_pro = AegisWAF_Features::is_pro();
        $status = strtoupper( (string) ( $data['status'] ?? 'inactive' ) );
        $plan   = (string) ( $data['plan'] ?? '—' );
        $exp    = (string) ( $data['expires_at'] ?? '—' );
		
		echo '<div class="wrap">';
        echo '<h1>License and Upgrades</h1>';
        AegisWAF_Pro_Notice::render();
        echo '<p class="description">The Licensing tab manages FREE and PRO activation status and ensures the correct feature set is enforced. It handles license validation, update channel access, and feature unlocking without interrupting site operation. Pro licenses enable advanced protections and ensure access to enhanced updates, while Free users retain core WAF functionality with clear upgrade visibility.</p>';

        echo '<div class="aegiswaf-card"><h3>License &amp; Upgrades</h3>';
        echo '<div class="aegiswaf-kv">';
        echo '<div class="item"><strong>Status</strong><div>' . esc_html( $status ) . '</div></div>';
        echo '<div class="item"><strong>Plan</strong><div>' . esc_html( $plan ) . '</div></div>';
        echo '<div class="item"><strong>Expires</strong><div>' . esc_html( $exp ) . '</div></div>';
        echo '</div></div>';

        echo '<div class="aegiswaf-card"><h3>Manage License</h3>';
		echo '<h4>';
		printf(
			wp_kses_post(
				__( 'Create an account on <a href="%1$s" target="_blank" rel="noopener noreferrer">%1$s</a> and help support Aegisify by buying a license today!', 'aegiswaf' )
			),
			esc_url( 'https://aegisify.com/register/' )
		);
		echo '</h4>';

		echo '<hr />';
        echo '<p class="description">Auto-updates are delivered via CLM. After activation, visit <strong>Dashboard → Updates</strong> or click <em>Check Again</em> on Plugins.</p>';
        echo '<form method="post">';
        wp_nonce_field( 'aegiswaf_license_action' );

        echo '<table class="form-table"><tbody>';
        echo '<tr><th>License Key</th><td><input type="text" name="license_key" value="' . esc_attr( $data['license_key'] ?? '' ) . '" style="width:420px;"></td></tr>';
        echo '<tr><th>License Email</th><td><input type="email" name="license_email" value="' . esc_attr( $data['license_email'] ?? '' ) . '" style="width:420px;"></td></tr>';
        echo '</tbody></table>';

        $confirm = esc_js( __( 'Deactivate this license on this site?', 'aegiswaf' ) );

        echo '<p>';
        echo '<button class="button button-primary" name="aegiswaf_activate_license" value="1">Activate License</button> ';
        echo '<button class="button" name="aegiswaf_deactivate_license" value="1" onclick="return confirm(\'' . $confirm . '\');">Deactivate</button>';
        echo '</p></form></div>';
		?>

		<div style="margin-top:18px;padding:16px;border:1px solid #dcdcde;background:#fff;border-radius:8px;">
			<div style="display:flex;align-items:center;gap:10px;margin-bottom:12px;">
				<div style="font-size:18px;font-weight:700;line-height:1.2;">🔓 FREE vs PRO Feature Comparison</div>
			</div>
			<div style="color:#50575e;font-size:13px;margin-bottom:14px;">
				Compare what’s included in FREE versus what unlocks in PRO. (No scripts required)
			</div>

			<?php
			$sections = [
				'Overview Dashboard' => [
					'Security Overview Summary' => [true, true],
					'Module Status Indicators' => [true, true],
					'Threat Metrics + Charts (last 24h)' => [true, true],
				],
				'Activity Logs' => [
					'Core Event Logging' => [true, true],
					'Basic Filtering' => [true, true],
					'Advanced Filtering (date range, alerts-only)' => [true, true],
					'Attack Story (narrative incident view)' => [false, true],
					'Alert Settings (keyword + email notifications)' => [false, true],
					'Retention Controls + Cleanup' => [false, true],
				],
				'WAF Rules' => [
					'Core Rule Engine' => [true, true],
					'Default Rule Presets' => [true, true],
					'Managed Rules: SQLi / XSS / Path Traversal' => [true, true],
					'Extended Managed Rules: RCE / CMD / SSRF / File Upload' => [false, true],
					'Heuristic Detection' => [true, true],
					'Heuristic Tuning + False Positive Controls' => [false, true],
					'Custom Rules & Overrides (up to 5 rules in FREE)' => [true, true],
					'Unlimited Custom Rules' => [false, true],
				],
				'Bot Control' => [
					'Bad Bot Blocking (UA-based)' => [true, true],
					'Rate-based Detection (per-path limits)' => [true, true],
					'Behavioral Bot Scoring (PRO enforcement)' => [false, true],
				],
				'API Shield' => [
					'REST API Inspection + Normalization' => [true, true],
					'REST Protections (unauthenticated write, user enumeration, body size, content-type, CORS)' => [true, true],
					'Header / API Key Enforcement' => [true, true],
					'Advanced Per-Route Controls' => [false, true],
				],
				'Geo & ASN Protection' => [
					'IP / CIDR Blocklist' => [false, true],
					'Country Blocking' => [false, true],
					'ASN Blocking' => [false, true],
					'Geo/ASN Provider Support (Cloudflare headers / MaxMind PHP ext)' => [false, true],
				],
				'DDoS Protection' => [
					'Basic Layer7 Rate Limiting (default groups)' => [true, true],
					'Progressive Mitigation (Challenge → Rate Limit → Block)' => [true, true],
					'Allowlist' => [true, true],
					'Per-Group Threshold Tuning' => [false, true],
					'Emergency Mode + Multiplier Tuning' => [false, true],
				],
			];

			$is_pro = ( class_exists('AegisWAF_License_Manager') && method_exists('AegisWAF_License_Manager', 'is_pro') )
				? (bool) AegisWAF_License_Manager::is_pro()
				: false;

			foreach ( $sections as $title => $features ) :
			?>

			<details style="border:1px solid #dcdcde;border-radius:8px;background:#f6f7f7;margin:0 0 10px 0;overflow:hidden;">
				<summary style="list-style:none;cursor:pointer;padding:12px 14px;font-weight:700;display:flex;align-items:center;justify-content:space-between;">
					<span><?php echo esc_html($title); ?></span>
					<span style="color:#646970;font-weight:600;">Click to expand</span>
				</summary>

				<div style="background:#fff;padding:12px 14px;border-top:1px solid #dcdcde;">
					<table style="width:100%;border-collapse:collapse;">
						<thead>
							<tr>
								<th style="text-align:left;padding:8px;border-bottom:1px solid #e5e5e5;">Feature</th>
								<th style="width:70px;text-align:center;padding:8px;border-bottom:1px solid #e5e5e5;">FREE</th>
								<th style="width:70px;text-align:center;padding:8px;border-bottom:1px solid #e5e5e5;">PRO</th>
							</tr>
						</thead>
						<tbody>
						<?php foreach ( $features as $feature => $access ) : ?>
							<tr>
								<td style="padding:8px;border-bottom:1px solid #f0f0f1;"><?php echo esc_html($feature); ?></td>
								<td style="text-align:center;padding:8px;border-bottom:1px solid #f0f0f1;">
									<?php if ( ! empty($access[0]) ) : ?>
										<span style="display:inline-block;font-weight:900;color:#1f8f3a;">✔</span>
									<?php else : ?>
										<span style="display:inline-block;font-weight:900;color:#8c8f94;">✖</span>
									<?php endif; ?>
								</td>
								<td style="text-align:center;padding:8px;border-bottom:1px solid #f0f0f1;">
									<?php if ( ! empty($access[1]) ) : ?>
										<span style="display:inline-block;font-weight:900;color:#1f8f3a;">✔</span>
									<?php else : ?>
										<span style="display:inline-block;font-weight:900;color:#8c8f94;">✖</span>
									<?php endif; ?>
								</td>
							</tr>
						<?php endforeach; ?>
						</tbody>
					</table>

					<?php if ( ! $is_pro ) : ?>
						<div style="margin-top:12px;display:flex;justify-content:flex-end;">
							<a href="https://aitechave.com/aegiswaf-pro" target="_blank"
							   style="text-decoration:none;background:#2271b1;color:#fff;padding:8px 12px;border-radius:6px;font-weight:700;">
								Upgrade to AegisWAF Pro
							</a>
						</div>
					<?php endif; ?>
				</div>
			</details>

			<?php endforeach; ?>

		</div>
		<?php
    } 
} 